<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class InsightsAssessmentsCommentOptions {
    /**
     * @param string $token The Token HTTP request header
     * @return CreateInsightsAssessmentsCommentOptions Options builder
     */
    public static function create(string $token = Values::NONE): CreateInsightsAssessmentsCommentOptions {
        return new CreateInsightsAssessmentsCommentOptions($token);
    }

    /**
     * @param string $segmentId Segment Id.
     * @param string $agentId Agent Id.
     * @param string $token The Token HTTP request header
     * @return ReadInsightsAssessmentsCommentOptions Options builder
     */
    public static function read(string $segmentId = Values::NONE, string $agentId = Values::NONE, string $token = Values::NONE): ReadInsightsAssessmentsCommentOptions {
        return new ReadInsightsAssessmentsCommentOptions($segmentId, $agentId, $token);
    }
}

class CreateInsightsAssessmentsCommentOptions extends Options {
    /**
     * @param string $token The Token HTTP request header
     */
    public function __construct(string $token = Values::NONE) {
        $this->options['token'] = $token;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.CreateInsightsAssessmentsCommentOptions ' . $options . ']';
    }
}

class ReadInsightsAssessmentsCommentOptions extends Options {
    /**
     * @param string $segmentId Segment Id.
     * @param string $agentId Agent Id.
     * @param string $token The Token HTTP request header
     */
    public function __construct(string $segmentId = Values::NONE, string $agentId = Values::NONE, string $token = Values::NONE) {
        $this->options['segmentId'] = $segmentId;
        $this->options['agentId'] = $agentId;
        $this->options['token'] = $token;
    }

    /**
     * The id of the segment.
     *
     * @param string $segmentId Segment Id.
     * @return $this Fluent Builder
     */
    public function setSegmentId(string $segmentId): self {
        $this->options['segmentId'] = $segmentId;
        return $this;
    }

    /**
     * The id of the agent.
     *
     * @param string $agentId Agent Id.
     * @return $this Fluent Builder
     */
    public function setAgentId(string $agentId): self {
        $this->options['agentId'] = $agentId;
        return $this;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.ReadInsightsAssessmentsCommentOptions ' . $options . ']';
    }
}